<?php
/**
 * @author Mostafa Naguib
 * @copyright Maximum Develop
 * @FileCreated 4-11-2015 12:7
 * @FileModified 28-01-2017 11:07
 * @Contact http://www.max-dev.com/Mostafa.Naguib
 */

class Upload {
    var $image;
    var $mime;
    var $imageName;
    var $maxHeight=1150;
    var $maxWidth=500;
    var $quality=75;
    var $rotMode="CW";
    var $rotColor="FFCC00";
    public $Document = array('pdf','doc','docx','xls','xlsx','txt','csv');
    public $Image = array('jpg','jpeg','gif','png');
    public function UploadFile($file, $limitsize, $type, $path){
        $name = $file['name'];
        $tmp = $file['tmp_name'];
        $size = $file['size'];
        $vaildsize = 1024*1024*$limitsize;
        $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
        if(is_array($type)){
            $valid_formats = $type;
        } else {
            $valid_formats = ($type=='doc')? $this->Document : $this->Image;
        }

        if (in_array($ext, $valid_formats)){
            if ($size<$vaildsize){
                $actual_file_name = uniqid().'_'.time().".".$ext;
                do {
                    $actual_file_name = uniqid().'_'.time().rand(10000,99999).".".$ext;
                } while(file_exists($path.$actual_file_name));
                if(@move_uploaded_file($tmp,$path.$actual_file_name)) {
                    $respond['status'] = true;
                    $respond['msg'] = 'تم الرفع بنجاح';
                    $respond['file'] = $actual_file_name;
                } else {
                    $respond['status'] = false;
                    $respond['msg'] = 'لم بتم الرفع';
                    $respond['error'] = $file[error];
                    //$respond[path] = $path;
                }
            } else {
                $respond['status'] = false;
                $respond['msg'] = 'لم يتم الرفع مساحة الملف أكبر من المساحة المحددة';
            }
        } else {
            $respond['status'] = false;
            $respond['msg'] = 'لم يتم الرفع, نوع الملف غير معروف'.'الامتداد :'.$ext;
        }
        return $respond;
    }

    public function Thumbnail($file,$maxw,$maxh,$thumb,$quality){
        $filename = end(explode('/',$file));
        $this->Create($file, $maxw, $maxh, $quality);
        if($this->Save($thumb.$filename))
            return array('status'=>true,'msg'=>'تم الرفع بنجاح','file'=>$filename);
        else
            return array('status'=>false,'msg'=>'لم يتم الرفع');
    }

    # sets thumb max width
    function SetWidth($val){
        $this->maxWidth=$val;
    }
    # sets thumb max height
    function SetHeight($val){
        $this->maxHeight=$val;
    }

    # set thumb both width and height
    function SetSize($width, $height){
        $this->maxWidth=$width;
        $this->maxHeight=$height;
    }

    # set output quality
    function SetQuality($number){
        $this->quality=$number;
    }

    # destroy the resource
    function Destroy(){
        imagedestroy($this->image);
    }

    # rotate the image
    function Rotate($degrees, $mode=NULL, $bgcolor=NULL){
        if($mode!=NULL) $this->rotMode=strtoupper($mode);
        if($bgcolor!=NULL) $this->rotColor=$bgcolor;
        $bg=base_convert($this->rotColor, 16, 10);
        $img=$this->image;
        switch($this->rotMode){
            case "CW":
            case 1:
                $rotation=360-$degrees;
                break;
            case "CCW":
            case 2:
                $rotation=$degrees;
                break;
        }
        $img=imagerotate($this->image, $rotation, $bg);
        $this->image=$img;
    }

    # resize an image
    function Resize($img, $width, $height){
        $img_sizes=getimagesize($img);
        switch($img_sizes[2]){
            case 1:
                $source=imagecreatefromgif($img);
                $this->mime="GIF";
                break;
            case 2:
                $source=imagecreatefromjpeg($img);
                $this->mime="JPG";
                break;
            case 3:
                $source=imagecreatefrompng($img);
                $this->mime="PNG";
                break;
        }
        $thumb=imagecreatetruecolor($width, $height);
        imagecopyresized($thumb, $source, 0, 0, 0, 0, $width, $height, $img_sizes[0], $img_sizes[1]);
        $this->image=$thumb;
    }

    # create a thumb
    function Create($img, $maxwidth=NULL, $maxheight=NULL, $quality=NULL){
        if($maxwidth!=NULL) $this->maxWidth=$maxwidth;
        if($maxheight!=NULL) $this->maxHeight=$maxheight;
        if($quality!=NULL) $this->quality=$quality;
        if(file_exists($img)){
            $this->imageName=basename($img);
            $img_sizes	=	getimagesize($img);
            if($img_sizes[0] > $this->maxWidth || $img_sizes[1] > $this->maxHeight){
                $percent_width = $this->maxWidth / $img_sizes[0];
                $percent_height = $this->maxHeight / $img_sizes[1];
                $percent=min($percent_width, $percent_height);
            }else{
                $percent=1;
            }
            $width=$img_sizes[0]*$percent;
            $height=$img_sizes[1]*$percent;
            $this->Resize($img, $width, $height);
        }else{
            $this->image=imagecreate($this->maxWidth, $this->maxHeight);
            $line=$this->DecColors("FF0000");
            $fill=$this->DecColors("EFE6C2");
            $fillcolor = imagecolorallocate($this->image, $fill['r'], $fill['b'], $fill['g']);
            $linecolor     = imagecolorallocate($this->image, $line['r'], $line['b'], $line['g']);
            imagefill($this->image, 0, 0, $fillcolor);
            imagerectangle($this->image, 0, 0, ($this->maxWidth-1), ($this->maxHeight-1), $linecolor);
            imageline($this->image, 0, 0, $this->maxWidth, $this->maxHeight, $linecolor);
            imageline($this->image, 0, $this->maxHeight, $this->maxWidth, 0, $linecolor);
        }
    }

    # function taken from "http://ro2.php.net/manual/en/function.mkdir.php"
    function MakeDirectory($dir, $mode = 0777){
        if (is_dir($dir) || @mkdir($dir,$mode)) return TRUE;
        if (!$this->MakeDirectory(dirname($dir),$mode)) return FALSE;
        return @mkdir($dir,$mode);
    }

    # output the image
    function Output($print=true){
        if($print!=true){
            header('Content-type: application/force-download');
            header('Content-Transfer-Encoding: Binary');
            header('Content-Disposition: attachment; filename="'.$this->imageName.'"');
        }
        switch($this->mime){
            case "JPEG":
            case "JPG":
                header("Content-Type: image/jpeg");
                imagejpeg($this->image, NULL, $this->quality);
                break;
            case "GIF":
                header("Content-Type: image/gif");
                imagegif($this->image);
                break;
            case "PNG":
                header("Content-Type: image/png");
                imagepng($this->image);
                break;
            default :
                header("Content-Type: image/gif");
                imagegif($this->image);
        }
        $this->Destroy();
    }

    # save image
    function Save($path){
        if(!file_exists(dirname($path))){
            $this->MakeDirectory(dirname($path));
        }
        switch($this->mime){
            case "JPEG":
            case "JPG":
                imagejpeg($this->image, $path, $this->quality);
                break;
            case "GIF":
                imagegif($this->image, $path);
                break;
            case "PNG":
                imagepng($this->image, $path);
                break;
        }
        return true;
    }
    function DecColors($color){
        $color	=	str_replace("#", "", $color);
        $colors['r']	=	hexdec(substr($color, 0, 2));
        $colors['b']	=	hexdec(substr($color, 2, 2));
        $colors['g']=	hexdec(substr($color, 4, 2));
        return $colors;
    }
}
?>