<?php

function dd($data){
    echo "<pre>";
    die(var_dump($data));
}


//TODO read (select row or rows)
function FetchAllData($table,$className)
{
    $pdo = Database::connect();
    try{
        $statement = $pdo->prepare('SELECT * FROM `'.$table.'` ');
        $statement->execute();
        //Row Count
        //dd($statement->rowCount());

        return $statement->fetchAll(PDO::FETCH_CLASS, $className);
    } catch (Exception $e){
        die($e->getMessage());
    }

}


//TODO read (select row or rows)
function FetchOneRow($table,$className,$id)
{
    $pdo = Database::connect();
    try{
        $statement = $pdo->prepare('SELECT * FROM `'.$table.'` WHERE `id` = :id');
        $statement->bindValue(':id',$id,PDO::PARAM_INT);
        $statement->execute();
        $rows = $statement->fetchAll(PDO::FETCH_CLASS, $className);
        if($rows)
            return $rows;
        else
            die('Row not found');
    } catch (Exception $e){
        die($e->getMessage());
    }

}

//TODO create (Insert new row)
function NewRow($table,$data){
    $pdo = Database::connect();
    $keys = '`'.implode('`,`',array_keys($data)).'`';
    $valueNames = ':'.implode(',:',array_keys($data));

    try {
        //INSERT INTO `students` (`class_id`, `firstname`, `lastname`, `birthdate`) VALUES ('2', ':firstname', ':lastname', '1999-11-30');
        $statement = $pdo->prepare("INSERT INTO `$table` ($keys) VALUES ($valueNames)");

        foreach ($data as $key=>$val){
            $statement->bindValue(':'.$key,$val);
        }
        $statement->execute();
        return $pdo->lastInsertId();

    } catch (PDOException $e){
        if($e->getCode() == '23000'){
            $message = $e->getMessage();
            die('Can not register more than one time '.$message);
        } else {
            die($e->getMessage());
        }
    }

}


//reusable
//TODO update
function UpdateRow($table,$data,$id){
    $pdo = Database::connect();
    $valueNames = implode(',',array_map(function($onedata){return "`$onedata` = :$onedata";},array_keys($data)));

    try {
        //UPDATE `students` SET `firstname` = ':firstname', `lastname` = 'Mohamed' WHERE `students`.`id` = 11
        $statement = $pdo->prepare("UPDATE `$table` SET $valueNames WHERE id = :id");
        foreach ($data as $key => $val) {
            $statement->bindValue(':' . $key, $val);
        }
        $statement->bindValue(':id', $id);
        $statement->execute();
        return $statement->rowCount();
    } catch (PDOException $e){
        dd($e->getMessage());
    }
}


//TODO delete
function DeleteOneRow($table,$id){
    $pdo = Database::connect();
    try {
        $stat = $pdo->prepare("DELETE FROM `$table` WHERE id = :id");
        $stat->bindValue(':id', $id);
        $stat->execute();
        return $stat->rowCount();
    } catch (PDOException $e){
        dd($e->getMessage());
    }
}




function DontUse($table,$className,$id){
    $pdo = Database::connect();
    try{
        $statement = $pdo->prepare('SELECT * FROM `'.$table.'` WHERE `id` = ? ');
        $statement->bindParam(1,$id,PDO::PARAM_INT);
        $statement->execute();

        return $statement->fetchAll(PDO::FETCH_CLASS, $className);
    } catch (Exception $e){
        die($e->getMessage());
    }

}
