<?php

namespace vendors\Database;
abstract class Database extends \PDO {

    public function __construct()
    {
        global $config;
        $newconfig = $config['database'];
        try {
            parent::__construct($newconfig['dsn'] . $newconfig['dbname'], $newconfig['dbuser'], $newconfig['dbpass'], [
                parent::ATTR_ERRMODE => parent::ERRMODE_EXCEPTION
            ]);
        } catch (\PDOException $e){
            die($e->getMessage());
        }
    }


    public function FetchAllData()
    {
        try{
            $statement = $this->prepare('SELECT * FROM `'.$this->table.'` ');
            $statement->execute();
            //Row Count
            //dd($statement->rowCount());

            return $statement->fetchAll(parent::FETCH_CLASS, get_class($this));
        } catch (\PDOException $e){
            die($e->getMessage());
        }

    }

    public function FetchOneRow($id)
    {
        try{
            $statement = $this->prepare('SELECT * FROM `'.$this->table.'` WHERE `id` = :id');
            $statement->bindValue(':id',$id);
            $statement->execute();
            $rows = $statement->fetchAll(parent::FETCH_CLASS, get_class($this));
            if($rows)
                return $rows;
            else
                die('Row not found');
        } catch (\PDOException $e){
            die($e->getMessage());
        }

    }

//TODO create (Insert new row)
    public function NewRow($table,$data){
        $keys = '`'.implode('`,`',array_keys($data)).'`';
        $valueNames = ':'.implode(',:',array_keys($data));

        try {
            $statement = $this->prepare("INSERT INTO `$table` ($keys) VALUES ($valueNames)");

            foreach ($data as $key=>$val){
                $statement->bindValue(':'.$key,$val);
            }
            $statement->execute();
            return $this->lastInsertId();

        } catch (\PDOException $e){
            if($e->getCode() == '23000'){
                $message = $e->getMessage();
                die('Can not register more than one time '.$message);
            } else {
                die($e->getMessage());
            }
        }

    }


//reusable
//TODO update
    public function UpdateRow($data,$id){
        $valueNames = implode(',',array_map(function($onedata){return "`$onedata` = :$onedata";},array_keys($data)));

        try {
            $statement = $this->prepare("UPDATE `$this->table` SET $valueNames WHERE id = :id");
            foreach ($data as $key => $val) {
                $statement->bindValue(':' . $key, $val);
            }
            $statement->bindValue(':id', $id);
            $statement->execute();
            return $statement->rowCount();
        } catch (\PDOException $e){
            die($e->getMessage());
        }
    }


//TODO delete
    public function DeleteOneRow($id){
        try {
            $stat = $this->prepare("DELETE FROM `$this->table` WHERE id = :id");
            $stat->bindValue(':id', $id);
            $stat->execute();
            return $stat->rowCount();
        } catch (\PDOException $e){
            die($e->getMessage());
        }
    }
}

